
public class ListaSimples {

	NoSimples primeiro, ultimo;

	ListaSimples() {
		primeiro = null;
		ultimo = null;
	}

	public void inserirInicio(NoSimples novoNo) {
		if (primeiro == null) {
			primeiro = novoNo;
			ultimo = novoNo;
		} else {
			novoNo.proximo = primeiro;
			primeiro = novoNo;
		}
	}

	public String mostrarLista() {
		int i = 0;
		NoSimples noTemp = primeiro;
		String msg = "";
		while (noTemp != null) {
			msg = msg + "Posio: " + i + " , valor do n: " + noTemp.valor + "\n";
			noTemp = noTemp.proximo;
			i++;
		}
		return msg;
	}

	public String mostrarListaInvertida() {
		int i = contarNos() - 1;
		NoSimples noTemp = ultimo;
		String msg = "";
		while (i >= 0) {
			msg = msg + "Posio: " + i + " , valor do n: " + noTemp.valor + "\n";
			i--;
			noTemp = pega(i);
		}
		return msg;
	}

	public NoSimples pega(int posicao) {
		NoSimples noTemp = primeiro;
		int contador;
		for (contador = 0; contador < posicao; contador++) {
			noTemp = noTemp.proximo;
		}
		return noTemp;
	}

	public int contarNos() {
		int contador = 0;
		NoSimples noTemp = primeiro;
		while (noTemp != null) {
			contador++;
			noTemp = noTemp.proximo;
		}
		return contador;
	}

	public void inserirFinal(NoSimples novoNo) {
		novoNo.proximo = null;
		if (primeiro == null) {
			primeiro = novoNo;
			ultimo = novoNo;
		} else {
			ultimo.proximo = novoNo;
			ultimo = novoNo;
		}
	}

	public void inserirPosicao(NoSimples novoNo, int posicao) {
		NoSimples noTemp = primeiro;
		int posAuxiliar;
		int numNos = contarNos();

		if (posicao == 0)
			inserirInicio(novoNo);
		else if (posicao > numNos)
			inserirFinal(novoNo);
		else {
			posAuxiliar = 1;
			while (posicao > posAuxiliar) {
				noTemp = noTemp.proximo;
				posAuxiliar++;

			}
			novoNo.proximo = noTemp.proximo;
			noTemp.proximo = novoNo;

		}

	}

	public void removeDoFinal() {
		int quantidadeDeNos = contarNos();
		int ultimaPosicao = quantidadeDeNos - 1;
		NoSimples noTemp = primeiro;
		int contador;
		for (contador = 0; contador < ultimaPosicao - 1; contador++) {
			noTemp = noTemp.proximo;
		}
		noTemp.proximo = null;
		ultimo = noTemp;
	}

	public void removeDoComeco() {
		NoSimples novoPrimeiro = primeiro.proximo;
		primeiro.proximo = null;
		primeiro = novoPrimeiro;
	}

}
